#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_VbecsUserDivisionRole
	{
		private Division _testDiv;
		private VbecsUserDivisionRole _testDivRole;
		private UserRole _testRole;
		private bool _roleChangedEventFiredFlag;

		[SetUp]
		public void SetUp()
		{
			if( _testDiv == null )
				_testDiv = new Division( UnitTestConfig.TestDivisionCode );

			_testRole = new UserRole( Common.UserRoleType.AdministratorSupervisor );
			
			_testDivRole = new VbecsUserDivisionRole( _testDiv );
			_testDivRole.Role = _testRole;
			_testDivRole.IsActive = true;
			_testDivRole.RoleChanged += new EventHandler( RoleChangedEventTestHandler );

			_roleChangedEventFiredFlag = false;
		}

		[TearDown]
		public void TearDown()
		{
			_testDivRole = null;
			_roleChangedEventFiredFlag = false;
		}

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsNotNull( _testDivRole );
			Assert.AreEqual( _testDiv, _testDivRole.Division );
		}

		[Test]
		[ExpectedException( typeof(ArgumentNullException) )]
		public void Ctor_Fail()
		{
			new VbecsUserDivisionRole( null );
		}

		[Test]
		[ExpectedException(typeof(NotSupportedException))]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow _dr = GetEmptyDivRoleExportDataRowTemplate();
			_testDivRole.LoadDataRowFromThis( _dr );
		}

		private DataRow GetEmptyDivRoleExportDataRowTemplate()
		{
			DataTable _dt = new DataTable();			
			_dt.Columns.Add( TABLES.VamcDivision.DivisionCode, typeof(string) );
			_dt.Columns.Add( TABLES.UserRole.UserRoleId, typeof(int) );
			_dt.Columns.Add( ARTIFICIAL.UserDivisionRoleRecordStatusCode, typeof(char) );
			_dt.Columns.Add( ARTIFICIAL.UserDivisionRoleRowVersion, typeof(byte[]) );

			return _dt.NewRow();
		}

		[Test]
		[ExpectedException( typeof(NotSupportedException))]
		public void LoadDataRowFromThis_Fail()
		{
			_testDivRole.LoadDataRowFromThis( null );
		}

		[Test]
		public void Division_Pass()
		{
			Assert.AreEqual( _testDiv, _testDivRole.Division );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void Division_Fail() {}

		[Test]
		public void Role_Pass()
		{
			// Resetting the division role for the test case
			_testDivRole.Role = null;
			_roleChangedEventFiredFlag = false;

			_testDivRole.Role = _testRole;
			Assert.AreEqual( _testRole, _testDivRole.Role );
			Assert.IsTrue( _testDivRole.IsValid );
			Assert.IsTrue( !_testDivRole.IsRuleBroken( Common.VbecsBrokenRules.UserDivisionRole.Role ) );
			Assert.IsTrue( _roleChangedEventFiredFlag );
		}

		[Test]
		public void Role_Fail()
		{
			_testDivRole.Role = null;

			Assert.IsNull( _testDivRole.Role );
			Assert.IsTrue( !_testDivRole.IsValid );
			Assert.IsTrue( _testDivRole.IsRuleBroken( Common.VbecsBrokenRules.UserDivisionRole.Role ) );
			Assert.IsTrue( _roleChangedEventFiredFlag );
		}

		[Test]
		public void IsActive_Pass_1()
		{
			_testDivRole.IsActive = false;
			Assert.IsTrue( !_testDivRole.IsActive );
			Assert.IsTrue( _roleChangedEventFiredFlag );
		}

		[Test]
		public void IsActive_Pass_2()
		{
			// Resetting the division role for the test case
			_testDivRole.IsActive = false;

			_testDivRole.IsActive = true;
			Assert.IsTrue( _testDivRole.IsActive );
			Assert.IsTrue( _roleChangedEventFiredFlag );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IsActive_Fail() {}

		private void RoleChangedEventTestHandler( object sender, EventArgs e )
		{
			_roleChangedEventFiredFlag = true;
		}

		[Test]
		public void LoadDataRowFromThis_VbecsUser_Param_Pass()
		{
			VbecsUser user = new VbecsUser( );
			//
			DataTable dt = new DataTable();			
			dt.Columns.Add( TABLES.VbecsUser.VbecsUserId, typeof(string) );
			dt.Columns.Add( TABLES.VamcDivision.DivisionCode, typeof(string) );
			dt.Columns.Add( TABLES.UserRole.UserRoleId, typeof(int) );
			dt.Columns.Add( TABLES.BloodUnit.RecordStatusCode, typeof(string) );
			dt.Columns.Add( TABLES.BloodUnit.RowVersion, typeof(byte []) );
			//
			DataRow dr = dt.NewRow();
			//
			_testDivRole.LoadDataRowFromThis( dr, user );
			//
			Assert.IsNotNull( _testDivRole );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_VbecsUser_Param_Fail()
		{
		}
	}
}

#endif
